﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Entities
{
    public class StaticSpriteComponent : Component
    {
        Texture2D _sprite;
        SpriteBatch spriteBatch;

        public Texture2D Sprite
        {
            get { return _sprite; }
            set { _sprite = value; }
        }

        public StaticSpriteComponent(string name)
            : base(name)
        {
            spriteBatch = (SpriteBatch)CashierGame.Instance.Services.GetService(typeof(SpriteBatch));
        }

        public override void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(_sprite, Entity.Position, Color.White);
        }

        public override void CopyTo(Component component)
        {
            StaticSpriteComponent s = (StaticSpriteComponent)component;
            s.Sprite = this.Sprite;
            base.CopyTo(s);
        } 


    }
}
